/*
Snowflake Database grammar.
The MIT License (MIT).

Copyright (c) 2022, Michał Lorek.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// $antlr-format alignTrailingComments true, columnLimit 150, maxEmptyLinesToKeep 1, reflowComments false, useTab false
// $antlr-format allowShortRulesOnASingleLine true, allowShortBlocksOnASingleLine true, minEmptyLines 0, alignSemicolons ownLine
// $antlr-format alignColons trailing, singleLineOverrulesHangingColon true, alignLexerCommands true, alignLabels true, alignTrailers true

lexer grammar SnowflakeLexer;

options {
    caseInsensitive = true;
}

/* Commented tokens was initial but not yet used in rules. Uncomment then as needed or delete them if you're sure will be not used.*/

AAD_PROVISIONER_Q : '\'AAD_PROVISIONER\'';
ABORT             : 'ABORT';
//ABORT_AFTER_WAIT:                                      'ABORT_AFTER_WAIT';
ABORT_DETACHED_QUERY : 'ABORT_DETACHED_QUERY';
ABORT_STATEMENT      : 'ABORT_STATEMENT';
//ABSENT:                                                'ABSENT';
//ABSOLUTE:                                              'ABSOLUTE';
ACCESS       : 'ACCESS';
ACCOUNT      : 'ACCOUNT';
ACCOUNTADMIN : 'ACCOUNTADMIN';
ACCOUNTS     : 'ACCOUNTS';
ACTION       : 'ACTION';
//ACTIVE:                                                'ACTIVE';
ADD: 'ADD';
//ADMINISTER:                                            'ADMINISTER';
ADMIN_NAME     : 'ADMIN_NAME';
ADMIN_PASSWORD : 'ADMIN_PASSWORD';
AES            : 'AES';
AFTER          : 'AFTER';
//AGGREGATE:                                             'AGGREGATE';
ALERT  : 'ALERT';
ALERTS : 'ALERTS';
ALL    : 'ALL';
//ALLOWED:                                               'ALLOWED';
ALLOWED_ACCOUNTS          : 'ALLOWED_ACCOUNTS';
ALLOWED_DATABASES         : 'ALLOWED_DATABASES';
ALLOWED_INTEGRATION_TYPES : 'ALLOWED_INTEGRATION_TYPES';
ALLOWED_IP_LIST           : 'ALLOWED_IP_LIST';
ALLOWED_SHARES            : 'ALLOWED_SHARES';
ALLOWED_VALUES            : 'ALLOWED_VALUES';
ALLOW_CLIENT_MFA_CACHING  : 'ALLOW_CLIENT_MFA_CACHING';
//ALLOW_CONNECTIONS:                                     'ALLOW_CONNECTIONS';
ALLOW_DUPLICATE : 'ALLOW_DUPLICATE';
ALLOW_ID_TOKEN  : 'ALLOW_ID_TOKEN';
//ALLOW_MULTIPLE_EVENT_LOSS:                             'ALLOW_MULTIPLE_EVENT_LOSS';
ALLOW_OVERLAPPING_EXECUTION: 'ALLOW_OVERLAPPING_EXECUTION';
//ALLOW_SINGLE_EVENT_LOSS:                               'ALLOW_SINGLE_EVENT_LOSS';
ALTER: 'ALTER';
//ALWAYS:                                                'ALWAYS';
AND: 'AND';
//ANONYMOUS:                                             'ANONYMOUS';
ANY                  : 'ANY';
ANY_VALUE            : 'ANY_VALUE';
API                  : 'API';
API_ALLOWED_PREFIXES : 'API_ALLOWED_PREFIXES';
API_AUTHENTICATION   : 'API_AUTHENTICATION';
API_AWS_ROLE_ARN     : 'API_AWS_ROLE_ARN';
API_BLOCKED_PREFIXES : 'API_BLOCKED_PREFIXES';
API_INTEGRATION      : 'API_INTEGRATION';
API_KEY              : 'API_KEY';
API_PROVIDER         : 'API_PROVIDER';
APPEND               : 'APPEND';
APPEND_ONLY          : 'APPEND_ONLY';
APPLICATION          : 'APPLICATION';
APPLY: 'APPLY';
//APP_NAME:                                              'APP_NAME';
ARRAY_AGG                       : 'ARRAY_AGG';
AS                              : 'AS';
ASC                             : 'ASC';
ASOF                            : 'ASOF';
ATTACH                          : 'ATTACH';
AT_KEYWORD                      : 'AT';
AUTHORIZATION                   : 'AUTHORIZATION';
AUTHORIZATIONS                  : 'AUTHORIZATIONS';
AUTO                            : 'AUTO';
AUTO_Q                          : '\'AUTO\'';
AUTOCOMMIT                      : 'AUTOCOMMIT';
AUTOCOMMIT_API_SUPPORTED        : 'AUTOCOMMIT_API_SUPPORTED';
AUTOINCREMENT                   : 'AUTOINCREMENT';
AUTO_COMPRESS                   : 'AUTO_COMPRESS';
AUTO_DETECT                     : 'AUTO_DETECT';
AUTO_INGEST                     : 'AUTO_INGEST';
AUTO_REFRESH                    : 'AUTO_REFRESH';
AUTO_RESUME                     : 'AUTO_RESUME';
AUTO_SUSPEND                    : 'AUTO_SUSPEND';
AVG                             : 'AVG';
AVRO                            : 'AVRO';
AVRO_Q                          : '\'AVRO\'';
AWS_KEY_ID                      : 'AWS_KEY_ID';
AWS_ROLE                        : 'AWS_ROLE';
AWS_SECRET_KEY                  : 'AWS_SECRET_KEY';
AWS_SNS                         : 'AWS_SNS';
AWS_SNS_ROLE_ARN                : 'AWS_SNS_ROLE_ARN';
AWS_SNS_TOPIC                   : 'AWS_SNS_TOPIC';
AWS_SNS_TOPIC_ARN               : 'AWS_SNS_TOPIC_ARN';
AWS_TOKEN                       : 'AWS_TOKEN';
AZURE                           : 'AZURE';
AZURE_AD_APPLICATION_ID         : 'AZURE_AD_APPLICATION_ID';
AZURE_CSE_Q                     : '\'AZURE_CSE\'';
AZURE_EVENT_GRID                : 'AZURE_EVENT_GRID';
AZURE_EVENT_GRID_TOPIC_ENDPOINT : 'AZURE_EVENT_GRID_TOPIC_ENDPOINT';
AZURE_Q                         : '\'AZURE\'';
AZURE_SAS_TOKEN                 : 'AZURE_SAS_TOKEN';
AZURE_STORAGE_QUEUE_PRIMARY_URI : 'AZURE_STORAGE_QUEUE_PRIMARY_URI';
AZURE_TENANT_ID                 : 'AZURE_TENANT_ID';
BASE64                          : 'BASE64';
BEFORE                          : 'BEFORE';
BEGIN                           : 'BEGIN';
BERNOULLI                       : 'BERNOULLI';
BETWEEN                         : 'BETWEEN';
BINARY_AS_TEXT                  : 'BINARY_AS_TEXT';
//BINARY_CHECKSUM:                                       'BINARY_CHECKSUM';
BINARY_FORMAT        : 'BINARY_FORMAT';
BINARY_INPUT_FORMAT  : 'BINARY_INPUT_FORMAT';
BINARY_OUTPUT_FORMAT : 'BINARY_OUTPUT_FORMAT';
//BINDING:                                               'BINDING';
BLOCK              : 'BLOCK';
BLOCKED_IP_LIST    : 'BLOCKED_IP_LIST';
BLOCKED_ROLES_LIST : 'BLOCKED_ROLES_LIST';
BODY               : 'BODY';
BOTH_Q             : '\'BOTH\'';
BRANCHES           : 'BRANCHES';
BROTLI             : 'BROTLI';
BUSINESS_CRITICAL  : 'BUSINESS_CRITICAL';
BY                 : 'BY';
BZ2                : 'BZ2';
//CACHE:                                                 'CACHE';
CALL             : 'CALL';
CALLED           : 'CALLED';
CALLER           : 'CALLER';
CASCADE          : 'CASCADE';
CASE             : 'CASE';
CASE_INSENSITIVE : 'CASE_INSENSITIVE';
CASE_SENSITIVE   : 'CASE_SENSITIVE';
CAST             : 'CAST';
CEIL             : 'CEIL';
//CATCH:                                                 'CATCH';
//CERTIFICATE:                                           'CERTIFICATE';
//CHANGE:                                                'CHANGE';
CHANGES: 'CHANGES';
//CHANGETABLE:                                           'CHANGETABLE';
//CHANGE_RETENTION:                                      'CHANGE_RETENTION';
CHANGE_TRACKING : 'CHANGE_TRACKING';
CHANNELS        : 'CHANNELS';
CHAR            : 'CHAR';
CHARACTER       : 'CHARACTER';
CHARINDEX       : 'CHARINDEX';
CHECK           : 'CHECK';
CHECKSUM        : 'CHECKSUM';
//CHECK_EXPIRATION:                                      'CHECK_EXPIRATION';
//CHECK_POLICY:                                          'CHECK_POLICY';
//CLASSIFIER_FUNCTION:                                   'CLASSIFIER_FUNCTION';
//CLEANUP:                                               'CLEANUP';
CLIENT_ENABLE_LOG_INFO_STATEMENT_PARAMETERS   : 'CLIENT_ENABLE_LOG_INFO_STATEMENT_PARAMETERS';
CLIENT_ENCRYPTION_KEY_SIZE                    : 'CLIENT_ENCRYPTION_KEY_SIZE';
CLIENT_MEMORY_LIMIT                           : 'CLIENT_MEMORY_LIMIT';
CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX    : 'CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX';
CLIENT_METADATA_USE_SESSION_DATABASE          : 'CLIENT_METADATA_USE_SESSION_DATABASE';
CLIENT_PREFETCH_THREADS                       : 'CLIENT_PREFETCH_THREADS';
CLIENT_RESULT_CHUNK_SIZE                      : 'CLIENT_RESULT_CHUNK_SIZE';
CLIENT_RESULT_COLUMN_CASE_INSENSITIVE         : 'CLIENT_RESULT_COLUMN_CASE_INSENSITIVE';
CLIENT_SESSION_KEEP_ALIVE                     : 'CLIENT_SESSION_KEEP_ALIVE';
CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY : 'CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY';
CLIENT_TIMESTAMP_TYPE_MAPPING                 : 'CLIENT_TIMESTAMP_TYPE_MAPPING';
CLONE                                         : 'CLONE';
CLOUD_PROVIDER_TOKEN                          : 'CLOUD_PROVIDER_TOKEN';
//CLOSE:                                                 'CLOSE';
CLUSTER: 'CLUSTER';
//CLUSTERED:                                             'CLUSTERED';
CLUSTERING : 'CLUSTERING';
COALESCE   : 'COALESCE';
COLLATE    : 'COLLATE';
COLLECTION : 'COLLECTION';
COLUMN     : 'COLUMN';
COLUMNS    : 'COLUMNS';
COMMENT    : 'COMMENT';
COMMIT     : 'COMMIT';
//COMMITTED:                                             'COMMITTED';
//COMPRESS:                                              'COMPRESS';
COMPRESSION : 'COMPRESSION';
CONCAT      : 'CONCAT';
// CONCAT_NULL_YIELDS_NULL:                               'CONCAT_NULL_YIELDS_NULL';
CONCAT_WS     : 'CONCAT_WS';
CONDITION     : 'CONDITION';
CONFIGURATION : 'CONFIGURATION';
CONNECT       : 'CONNECT';
CONNECTION    : 'CONNECTION';
CONNECTIONS   : 'CONNECTIONS';
CONSTRAINT    : 'CONSTRAINT';
// CONTAINMENT:                                           'CONTAINMENT';
CONTAINS: 'CONTAINS';
// CONTENT:                                               'CONTENT';
// CONTEXT:                                               'CONTEXT';
CONTEXT_HEADERS: 'CONTEXT_HEADERS';
// CONTEXT_INFO:                                          'CONTEXT_INFO';
CONTINUE: 'CONTINUE';
// CONTROL:                                               'CONTROL';
// CONVERSATION:                                          'CONVERSATION';
// COOKIE:                                                'COOKIE';
COPY: 'COPY';
// COPY_ONLY:                                             'COPY_ONLY';
COPY_OPTIONS_ : 'COPY_OPTIONS';
COUNT         : 'COUNT';
CREATE        : 'CREATE';
CREDENTIALS   : 'CREDENTIALS';
CREDIT_QUOTA  : 'CREDIT_QUOTA';
CROSS         : 'CROSS';
CSV           : 'CSV';
CSV_Q         : '\'CSV\'';
CUBE          : 'CUBE';
// CUME_DIST:                                             'CUME_DIST';
CURRENT           : 'CURRENT';
CURRENT_DATE      : 'CURRENT_DATE';
CURRENT_TIME      : 'CURRENT_TIME';
CURRENT_TIMESTAMP : 'CURRENT_TIMESTAMP';
// CURRENT_USER:                                          'CURRENT_USER';
// CURSOR:                                                'CURSOR';
CUSTOM                      : 'CUSTOM';
DAILY                       : 'DAILY';
DATA                        : 'DATA';
DATABASE                    : 'DATABASE';
DATABASES                   : 'DATABASES';
DATASET                     : 'DATASET';
DATASETS                    : 'DATASETS';
DATA_RETENTION_TIME_IN_DAYS : 'DATA_RETENTION_TIME_IN_DAYS';
DATEADD                     : 'DATEADD';
DATEDIFF                    : 'DATEDIFF';
// DATENAME:                                              'DATENAME';
// DATEPART:                                              'DATEPART';
DATE_FORMAT        : 'DATE_FORMAT';
DATE_INPUT_FORMAT  : 'DATE_INPUT_FORMAT';
DATE_OUTPUT_FORMAT : 'DATE_OUTPUT_FORMAT';
DATE_PART          : 'DATE_PART';
DAYS               : 'DAYS';
DAYS_TO_EXPIRY     : 'DAYS_TO_EXPIRY';
// DECLARE:                                               'DECLARE';
DEFAULT                : 'DEFAULT';
DEFAULT_DDL_COLLATION_ : 'DEFAULT_DDL_COLLATION';
DEFAULT_NAMESPACE      : 'DEFAULT_NAMESPACE';
DEFAULT_ROLE           : 'DEFAULT_ROLE';
DEFAULT_WAREHOUSE      : 'DEFAULT_WAREHOUSE';
DEFERRABLE             : 'DEFERRABLE';
DEFERRED               : 'DEFERRED';
DEFINE                 : 'DEFINE';
DEFINITION             : 'DEFINITION';
DEFLATE                : 'DEFLATE';
DELEGATED              : 'DELEGATED';
DELETE                 : 'DELETE';
DELTA                  : 'DELTA';
DENSE_RANK             : 'DENSE_RANK';
DESC                   : 'DESC';
DESCRIBE               : 'DESCRIBE';
DIRECTED               : 'DIRECTED';
DIRECTION              : 'DIRECTION';
DIRECTORY              : 'DIRECTORY';
DISABLE                : 'DISABLE';
DISABLED               : 'DISABLED';
DISABLE_AUTO_CONVERT   : 'DISABLE_AUTO_CONVERT';
DISABLE_SNOWFLAKE_DATA : 'DISABLE_SNOWFLAKE_DATA';
// DISK:                                                  'DISK';
DISPLAY_NAME                             : 'DISPLAY_NAME';
DISTINCT                                 : 'DISTINCT';
DO                                       : 'DO';
DOWNSTREAM                               : 'DOWNSTREAM';
DROP                                     : 'DROP';
DYNAMIC                                  : 'DYNAMIC';
ECONOMY                                  : 'ECONOMY';
EDITION                                  : 'EDITION';
ELSE                                     : 'ELSE';
EMAIL                                    : 'EMAIL';
EMPTY_                                   : 'EMPTY';
EMPTY_FIELD_AS_NULL                      : 'EMPTY_FIELD_AS_NULL';
ENABLE                                   : 'ENABLE';
ENABLED                                  : 'ENABLED';
ENABLE_FOR_PRIVILEGE                     : 'ENABLE_FOR_PRIVILEGE';
ENABLE_INTERNAL_STAGES_PRIVATELINK       : 'ENABLE_INTERNAL_STAGES_PRIVATELINK';
ENABLE_OCTAL                             : 'ENABLE_OCTAL';
ENABLE_QUERY_ACCELERATION                : 'ENABLE_QUERY_ACCELERATION';
ENABLE_UNLOAD_PHYSICAL_TYPE_OPTIMIZATION : 'ENABLE_UNLOAD_PHYSICAL_TYPE_OPTIMIZATION';
ENCODING                                 : 'ENCODING';
ENCRYPTION                               : 'ENCRYPTION';
END                                      : 'END';
// ENDPOINT:                                              'ENDPOINT';
END_TIMESTAMP                    : 'END_TIMESTAMP';
ENFORCED                         : 'ENFORCED';
ENFORCE_LENGTH                   : 'ENFORCE_LENGTH';
ENFORCE_SESSION_POLICY           : 'ENFORCE_SESSION_POLICY';
ENTERPRISE                       : 'ENTERPRISE';
EQUAL_NULL                       : 'EQUAL_NULL';
EQUALITY                         : 'EQUALITY';
ERROR_INTEGRATION                : 'ERROR_INTEGRATION';
ERROR_ON_COLUMN_COUNT_MISMATCH   : 'ERROR_ON_COLUMN_COUNT_MISMATCH';
ERROR_ON_NONDETERMINISTIC_MERGE  : 'ERROR_ON_NONDETERMINISTIC_MERGE';
ERROR_ON_NONDETERMINISTIC_UPDATE : 'ERROR_ON_NONDETERMINISTIC_UPDATE';
ESCAPE                           : 'ESCAPE';
ESCAPE_UNENCLOSED_FIELD          : 'ESCAPE_UNENCLOSED_FIELD';
EVENT                            : 'EVENT';
EXCEPT                           : 'EXCEPT';
EXCLUDE                          : 'EXCLUDE';
EXCHANGE                         : 'EXCHANGE';
EXECUTE                          : 'EXEC' 'UTE'?;
EXECUTION                        : 'EXECUTION';
// EXIST:                                                 'EXIST';
EXISTS: 'EXISTS';
// EXIT:                                                  'EXIT';
// EXPAND:                                                'EXPAND';
EXPIRY_DATE : 'EXPIRY_DATE';
EXPLAIN     : 'EXPLAIN';
EXPR        : 'EXPR';
// EXPLICIT:                                              'EXPLICIT';
EXTRACT     : 'EXTRACT';
EXTERNAL       : 'EXTERNAL';
EXTERNAL_OAUTH : 'EXTERNAL_OAUTH';
EXTERNAL_OAUTH_ADD_PRIVILEGED_ROLES_TO_BLOCKED_LIST:
    'EXTERNAL_OAUTH_ADD_PRIVILEGED_ROLES_TO_BLOCKED_LIST'
;
EXTERNAL_OAUTH_ALLOWED_ROLES_LIST : 'EXTERNAL_OAUTH_ALLOWED_ROLES_LIST';
EXTERNAL_OAUTH_ANY_ROLE_MODE      : 'EXTERNAL_OAUTH_ANY_ROLE_MODE';
EXTERNAL_OAUTH_AUDIENCE_LIST      : 'EXTERNAL_OAUTH_AUDIENCE_LIST';
EXTERNAL_OAUTH_BLOCKED_ROLES_LIST : 'EXTERNAL_OAUTH_BLOCKED_ROLES_LIST';
EXTERNAL_OAUTH_ISSUER             : 'EXTERNAL_OAUTH_ISSUER';
EXTERNAL_OAUTH_JWS_KEYS_URL       : 'EXTERNAL_OAUTH_JWS_KEYS_URL';
EXTERNAL_OAUTH_RSA_PUBLIC_KEY     : 'EXTERNAL_OAUTH_RSA_PUBLIC_KEY';
EXTERNAL_OAUTH_RSA_PUBLIC_KEY_2   : 'EXTERNAL_OAUTH_RSA_PUBLIC_KEY_2';
EXTERNAL_OAUTH_SCOPE_DELIMITER    : 'EXTERNAL_OAUTH_SCOPE_DELIMITER';
EXTERNAL_OAUTH_SNOWFLAKE_USER_MAPPING_ATTRIBUTE:
    'EXTERNAL_OAUTH_SNOWFLAKE_USER_MAPPING_ATTRIBUTE'
;
EXTERNAL_OAUTH_TOKEN_USER_MAPPING_CLAIM : 'EXTERNAL_OAUTH_TOKEN_USER_MAPPING_CLAIM';
EXTERNAL_OAUTH_TYPE                     : 'EXTERNAL_OAUTH_TYPE';
EXTERNAL_STAGE                          : 'EXTERNAL_STAGE';
FAILOVER                                : 'FAILOVER';
// FAILOVER_MODE:                                         'FAILOVER_MODE';
// FAIL_OPERATION:                                        'FAIL_OPERATION';
FALSE                        : 'FALSE';
FETCH                        : 'FETCH';
FIELD_DELIMITER              : 'FIELD_DELIMITER';
FIELD_OPTIONALLY_ENCLOSED_BY : 'FIELD_OPTIONALLY_ENCLOSED_BY';
FILE                         : 'FILE';
FILES                        : 'FILES';
FILE_EXTENSION               : 'FILE_EXTENSION';
FILE_FORMAT                  : 'FILE_FORMAT';
// FILTER:                                                'FILTER';
FIRST                        : 'FIRST';
FIRST_NAME                   : 'FIRST_NAME';
FIRST_VALUE                  : 'FIRST_VALUE';
FLATTEN                      : 'FLATTEN';
FOLLOWING                    : 'FOLLOWING';
FOR                          : 'FOR';
FORCE                        : 'FORCE';
FOREIGN                      : 'FOREIGN';
FORMAT                       : 'FORMAT';
FORMATS                      : 'FORMATS';
FORMAT_NAME                  : 'FORMAT_NAME';
FREQUENCY                    : 'FREQUENCY';
FROM                         : 'FROM';
FULL                         : 'FULL';
FUNCTION                     : 'FUNCTION';
FUNCTIONS                    : 'FUNCTIONS';
FUTURE                       : 'FUTURE';
GCP_PUBSUB                   : 'GCP_PUBSUB';
GCP_PUBSUB_SUBSCRIPTION_NAME : 'GCP_PUBSUB_SUBSCRIPTION_NAME';
GCP_PUBSUB_TOPIC_NAME        : 'GCP_PUBSUB_TOPIC_NAME';
GCS                          : 'GCS';
GCS_SSE_KMS_Q                : '\'GCS_SSE_KMS\'';
GENERIC                      : 'GENERIC';
GENERIC_Q                    : '\'GENERIC\'';
GENERIC_SCIM_PROVISIONER_Q   : '\'GENERIC_SCIM_PROVISIONER\'';
GENERIC_STRING               : 'GENERIC_STRING';
GEO                          : 'GEO';
GEOGRAPHY_OUTPUT_FORMAT      : 'GEOGRAPHY_OUTPUT_FORMAT';
GEOMETRY_OUTPUT_FORMAT       : 'GEOMETRY_OUTPUT_FORMAT';
GET                          : 'GET';
GETDATE                      : 'GETDATE';
// GET_FILESTREAM_TRANSACTION_CONTEXT:                    'GET_FILESTREAM_TRANSACTION_CONTEXT';
GIT                          : 'GIT';
GIT_CREDENTIALS              : 'GIT_CREDENTIALS';
GLOBAL          : 'GLOBAL';
GOOGLE_AUDIENCE : 'GOOGLE_AUDIENCE';
// GOTO:                                                  'GOTO';
GRANT    : 'GRANT';
GRANTS   : 'GRANTS';
GROUP    : 'GROUP';
GROUPING : 'GROUPING';
// GROUPING_ID:                                           'GROUPING_ID';
GROUPS                : 'GROUPS';
GZIP                  : 'GZIP';
HALF_AWAY_FROM_ZERO_Q : '\'HALF_AWAY_FROM_ZERO\'';
HALF_TO_EVEN_Q        : '\'HALF_TO_EVEN\'';
HANDLER               : 'HANDLER';
HASH                  : 'HASH';
HAVING                : 'HAVING';
HEADER                : 'HEADER';
HEADERS               : 'HEADERS';
HEX                   : 'HEX';
// HIERARCHYID:                                           'HIERARCHYID';
HIGH       : 'HIGH';
HISTORY    : 'HISTORY';
HOURS      : 'HOURS';
IDENTIFIER : 'IDENTIFIER';
IDENTITY   : 'IDENTITY';
IF         : 'IF';
IFF        : 'IFF';
IFNULL     : 'IFNULL';
IGNORE     : 'IGNORE';
// IGNORE_CONSTRAINTS:                                    'IGNORE_CONSTRAINTS';
// IGNORE_DUP_KEY:                                        'IGNORE_DUP_KEY';
// IGNORE_NONCLUSTERED_COLUMNSTORE_INDEX:                 'IGNORE_NONCLUSTERED_COLUMNSTORE_INDEX';
// IGNORE_TRIGGERS:                                       'IGNORE_TRIGGERS';
IGNORE_UTF8_ERRORS : 'IGNORE_UTF8_ERRORS';
ILIKE              : 'ILIKE';
IMMEDIATE          : 'IMMEDIATE';
IMMEDIATELY        : 'IMMEDIATELY';
IMMUTABLE          : 'IMMUTABLE';
IMPLICIT           : 'IMPLICIT';
IMPORT             : 'IMPORT';
IMPORTS            : 'IMPORTS';
IMPORTED           : 'IMPORTED';
IN                 : 'IN';
INCREMENT          : 'INCREMENT';
INCREMENTAL        : 'INCREMENTAL';
INDEX              : 'INDEX';
INFORMATION        : 'INFORMATION';
// INIT:                                                  'INIT';
INITIALIZE                           : 'INITIALIZE';
INITIALLY                            : 'INITIALLY';
INITIALLY_SUSPENDED                  : 'INITIALLY_SUSPENDED';
INITIAL_REPLICATION_SIZE_LIMIT_IN_TB : 'INITIAL_REPLICATION_SIZE_LIMIT_IN_TB';
INNER                                : 'INNER';
INPUT                                : 'INPUT';
INSERT                               : 'INSERT';
INSERT_ONLY                          : 'INSERT_ONLY';
// INSTEAD:                                               'INSTEAD';
INT          : 'INT';
INTEGRATION  : 'INTEGRATION';
INTEGRATIONS : 'INTEGRATIONS';
INTERSECT    : 'INTERSECT';
INTERVAL     : 'INTERVAL';
INTO         : 'INTO';
IS           : 'IS';
// ISNUMERIC:                                             'ISNUMERIC';
// ISOLATION:                                             'ISOLATION';
JAVA                            : 'JAVA';
JAVASCRIPT                      : 'JAVASCRIPT';
JDBC_TREAT_DECIMAL_AS_INT       : 'JDBC_TREAT_DECIMAL_AS_INT';
JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC : 'JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC';
JDBC_USE_SESSION_TIMEZONE       : 'JDBC_USE_SESSION_TIMEZONE';
JOIN                            : 'JOIN';
JSON                            : 'JSON';
JSON_Q                          : '\'JSON\'';
JSON_INDENT                     : 'JSON_INDENT';
JS_TREAT_INTEGER_AS_BIGINT      : 'JS_TREAT_INTEGER_AS_BIGINT';
// KB:                                                    'KB';
// KEEP:                                                  'KEEP';
KEY  : 'KEY';
KEYS : 'KEYS';
// KEYSET:                                                'KEYSET';
KMS_KEY_ID    : 'KMS_KEY_ID';
LAG           : 'LAG';
LANGUAGE      : 'LANGUAGE';
LARGE         : 'LARGE';
LAST          : 'LAST';
LAST_NAME     : 'LAST_NAME';
LAST_QUERY_ID : 'LAST_QUERY_ID';
LAST_VALUE    : 'LAST_VALUE';
LATERAL       : 'LATERAL';
LEAD          : 'LEAD';
LEFT          : 'LEFT';
LEN           : 'LEN';
LENGTH        : 'LENGTH';
// LEVEL:                                                 'LEVEL';
LIKE   : 'LIKE';
LIMIT  : 'LIMIT';
LINEAR : 'LINEAR';
// LINENO:                                                'LINENO';
LIST: 'LIST';
// LISTENER_IP:                                           'LISTENER_IP';
// LISTENER_PORT:                                         'LISTENER_PORT';
LISTING: 'LISTING';
// LOAD:                                                  'LOAD';
LOCAL: 'LOCAL';
// LOCAL_SERVICE_NAME:                                    'LOCAL_SERVICE_NAME';
LOCATION     : 'LOCATION';
LOCKS        : 'LOCKS';
LOCK_TIMEOUT : 'LOCK_TIMEOUT';
// LOG:                                                   'LOG';
// LOGIN:                                                 'LOGIN';
LOGIN_NAME : 'LOGIN_NAME';
LOOKER     : 'LOOKER';
LOW        : 'LOW';
LOWER      : 'LOWER';
LTRIM      : 'LTRIM';
LZO        : 'LZO';
MANAGE     : 'MANAGE';
MANAGED    : 'MANAGED';
// MASK:                                                  'MASK';
// MASKED:                                                'MASKED';
MASKING: 'MASKING';
// MASTER:                                                'MASTER';
MASTER_KEY                      : 'MASTER_KEY';
MATCH                           : 'MATCH';
MATCH_CONDITION                 : 'MATCH_CONDITION';
MATCHED                         : 'MATCHED';
MATCHES                         : 'MATCHES';
MATCH_BY_COLUMN_NAME            : 'MATCH_BY_COLUMN_NAME';
MATCH_RECOGNIZE                 : 'MATCH_RECOGNIZE';
MATERIALIZED                    : 'MATERIALIZED';
MAX_BATCH_ROWS                  : 'MAX_BATCH_ROWS';
MAX_CLUSTER_COUNT               : 'MAX_CLUSTER_COUNT';
MAX_CONCURRENCY_LEVEL           : 'MAX_CONCURRENCY_LEVEL';
MAX_DATA_EXTENSION_TIME_IN_DAYS : 'MAX_DATA_EXTENSION_TIME_IN_DAYS';
MAX_SIZE                        : 'MAX_SIZE';
MEASURES                        : 'MEASURES';
MEDIUM                          : 'MEDIUM';
MEMOIZABLE                      : 'MEMOIZABLE';
MERGE                           : 'MERGE';
METADATA                        : 'METADATA';
MIDDLE_NAME                     : 'MIDDLE_NAME';
MIN                             : 'MIN';
MINS_TO_BYPASS_MFA              : 'MINS_TO_BYPASS_MFA';
MINS_TO_UNLOCK                  : 'MINS_TO_UNLOCK';
MINUS_                          : 'MINUS';
// MINUTES:                                               'MINUTES';
MIN_CLUSTER_COUNT               : 'MIN_CLUSTER_COUNT';
MIN_DATA_RETENTION_TIME_IN_DAYS : 'MIN_DATA_RETENTION_TIME_IN_DAYS';
MODE                            : 'MODE';
MODIFIED_AFTER                  : 'MODIFIED_AFTER';
MODIFY                          : 'MODIFY';
MONITOR                         : 'MONITOR';
MONITORS                        : 'MONITORS';
MONTHLY                         : 'MONTHLY';
MOVE                            : 'MOVE';
MULTI_STATEMENT_COUNT           : 'MULTI_STATEMENT_COUNT';
// MULTI_USER:                                            'MULTI_USER';
// MUST_CHANGE:                                           'MUST_CHANGE';
MUST_CHANGE_PASSWORD : 'MUST_CHANGE_PASSWORD';
NAME                 : 'NAME';
NATURAL              : 'NATURAL';
// NESTED_TRIGGERS:                                       'NESTED_TRIGGERS';
NETWORK        : 'NETWORK';
NETWORK_POLICY : 'NETWORK_POLICY';
NEVER          : 'NEVER';
// NEWID:                                                 'NEWID';
// NEWNAME:                                               'NEWNAME';
// NEWSEQUENTIALID:                                       'NEWSEQUENTIALID';
// NEW_ACCOUNT:                                           'NEW_ACCOUNT';
// NEW_BROKER:                                            'NEW_BROKER';
// NEW_PASSWORD:                                          'NEW_PASSWORD';
NEXT         : 'NEXT';
NEXTVAL      : 'NEXTVAL';
NO           : 'NO';
NONE         : 'NONE';
NONE_Q       : '\'NONE\'';
NOORDER      : 'NOORDER';
NORELY       : 'NORELY';
NOT          : 'NOT';
NOTIFICATION : 'NOTIFICATION';
// NOTIFICATIONS:                                         'NOTIFICATIONS';
NOTIFICATION_INTEGRATION         : 'NOTIFICATION_INTEGRATION';
NOTIFICATION_PROVIDER            : 'NOTIFICATION_PROVIDER';
NOTIFY                           : 'NOTIFY';
NOTIFY_USERS                     : 'NOTIFY_USERS';
NOVALIDATE                       : 'NOVALIDATE';
NTILE                            : 'NTILE';
NULLIF                           : 'NULLIF';
NULLS                            : 'NULLS';
NULL_                            : 'NULL';
NULL_IF                          : 'NULL_IF';
NUMBER                           : 'NUMBER';
NVL                              : 'NVL';
NVL2                             : 'NVL2';
OAUTH                            : 'OAUTH';
OAUTH2                           : 'OAUTH2';
OAUTH_ALLOW_NON_TLS_REDIRECT_URI : 'OAUTH_ALLOW_NON_TLS_REDIRECT_URI';
OAUTH_CLIENT                     : 'OAUTH_CLIENT';
OAUTH_CLIENT_RSA_PUBLIC_KEY      : 'OAUTH_CLIENT_RSA_PUBLIC_KEY';
OAUTH_CLIENT_RSA_PUBLIC_KEY_2    : 'OAUTH_CLIENT_RSA_PUBLIC_KEY_2';
OAUTH_ENFORCE_PKCE               : 'OAUTH_ENFORCE_PKCE';
OAUTH_ISSUE_REFRESH_TOKENS       : 'OAUTH_ISSUE_REFRESH_TOKENS';
OAUTH_REDIRECT_URI               : 'OAUTH_REDIRECT_URI';
OAUTH_REFRESH_TOKEN              : 'OAUTH_REFRESH_TOKEN';
OAUTH_REFRESH_TOKEN_EXPIRY_TIME  : 'OAUTH_REFRESH_TOKEN_EXPIRY_TIME';
OAUTH_REFRESH_TOKEN_VALIDITY     : 'OAUTH_REFRESH_TOKEN_VALIDITY';
OAUTH_SCOPES                     : 'OAUTH_SCOPES';
OAUTH_USE_SECONDARY_ROLES        : 'OAUTH_USE_SECONDARY_ROLES';
OBJECT                           : 'OBJECT';
OBJECT_Q                         : '\'OBJECT\'';
OBJECTS                          : 'OBJECTS';
OBJECT_TYPES                     : 'OBJECT_TYPES';
OF                               : 'OF';
// OFF:                                                   'OFF';
OFFSET: 'OFFSET';
// OFFSETS:                                               'OFFSETS';
OKTA               : 'OKTA';
OKTA_PROVISIONER_Q : '\'OKTA_PROVISIONER\'';
OKTA_Q             : '\'OKTA\'';
OLD                : 'OLD';
// OLD_ACCOUNT:                                           'OLD_ACCOUNT';
// OLD_PASSWORD:                                          'OLD_PASSWORD';
OMIT : 'OMIT';
ON   : 'ON';
ONE  : 'ONE';
// ONLINE:                                                'ONLINE';
ONLY        : 'ONLY';
ON_CREATE   : 'ON_CREATE';
ON_ERROR    : 'ON_ERROR';
ON_SCHEDULE : 'ON_SCHEDULE';
// ON_FAILURE:                                            'ON_FAILURE';
// OPEN:                                                  'OPEN';
OPERATE: 'OPERATE';
// OPERATIONS:                                            'OPERATIONS';
OPTIMIZATION : 'OPTIMIZATION';
OPTION       : 'OPTION';
OR           : 'OR';
ORC          : 'ORC';
ORC_Q        : '\'ORC\'';
ORDER        : 'ORDER';
ORGADMIN     : 'ORGADMIN';
ORGANIZATION : 'ORGANIZATION';
ORIGIN       : 'ORIGIN';
OUTBOUND     : 'OUTBOUND';
OUTER        : 'OUTER';
OVER         : 'OVER';
OVERRIDE     : 'OVERRIDE';
OVERWRITE    : 'OVERWRITE';
OWNER        : 'OWNER';
OWNERSHIP    : 'OWNERSHIP';
PACKAGE      : 'PACKAGE';
PACKAGES     : 'PACKAGES';
// PAGE:                                                  'PAGE';
PARALLEL   : 'PARALLEL';
PARAMETERS : 'PARAMETERS';
// PARAM_NODE:                                            'PARAM_NODE';
PARQUET   : 'PARQUET';
PARQUET_Q : '\'PARQUET\'';
PARTIAL   : 'PARTIAL';
PARTITION : 'PARTITION';
// PARTITIONS:                                            'PARTITIONS';
PARTITION_TYPE                : 'PARTITION_TYPE';
PASSWORD                      : 'PASSWORD';
PASSWORD_HISTORY              : 'PASSWORD_HISTORY';
PASSWORD_LOCKOUT_TIME_MINS    : 'PASSWORD_LOCKOUT_TIME_MINS';
PASSWORD_MAX_AGE_DAYS         : 'PASSWORD_MAX_AGE_DAYS';
PASSWORD_MAX_LENGTH           : 'PASSWORD_MAX_LENGTH';
PASSWORD_MAX_RETRIES          : 'PASSWORD_MAX_RETRIES';
PASSWORD_MIN_AGE_DAYS         : 'PASSWORD_MIN_AGE_DAYS';
PASSWORD_MIN_LENGTH           : 'PASSWORD_MIN_LENGTH';
PASSWORD_MIN_LOWER_CASE_CHARS : 'PASSWORD_MIN_LOWER_CASE_CHARS';
PASSWORD_MIN_NUMERIC_CHARS    : 'PASSWORD_MIN_NUMERIC_CHARS';
PASSWORD_MIN_SPECIAL_CHARS    : 'PASSWORD_MIN_SPECIAL_CHARS';
PASSWORD_MIN_UPPER_CASE_CHARS : 'PASSWORD_MIN_UPPER_CASE_CHARS';
PAST                          : 'PAST';
PATH_                         : 'PATH';
PATTERN                       : 'PATTERN';
PER                           : 'PER';
PERCENT                       : 'PERCENT';
// PERCENTILE_CONT:                                       'PERCENTILE_CONT';
// PERCENTILE_DISC:                                       'PERCENTILE_DISC';
// PERCENT_RANK:                                          'PERCENT_RANK';
PERIODIC_DATA_REKEYING: 'PERIODIC_DATA_REKEYING';
// PERMISSION_SET:                                        'PERMISSION_SET';
// PERSISTED:                                             'PERSISTED';
// PERSIST_SAMPLE_PERCENT:                                'PERSIST_SAMPLE_PERCENT';
PING_FEDERATE         : 'PING_FEDERATE';
PIPE                  : 'PIPE';
PIPES                 : 'PIPES';
PIPE_EXECUTION_PAUSED : 'PIPE_EXECUTION_PAUSED';
PIVOT                 : 'PIVOT';
// PLAN:                                                  'PLAN';
// PLATFORM:                                              'PLATFORM';
POLICIES : 'POLICIES';
POLICY   : 'POLICY';
// POOL:                                                  'POOL';
PORT: 'PORT';
PRECEDING: 'PRECEDING';
// PREDICATE:                                             'PREDICATE';
PREFIX                            : 'PREFIX';
PRESERVE_SPACE                    : 'PRESERVE_SPACE';
PREVENT_UNLOAD_TO_INLINE_URL      : 'PREVENT_UNLOAD_TO_INLINE_URL';
PREVENT_UNLOAD_TO_INTERNAL_STAGES : 'PREVENT_UNLOAD_TO_INTERNAL_STAGES';
PRE_AUTHORIZED_ROLES_LIST         : 'PRE_AUTHORIZED_ROLES_LIST';
PRIMARY                           : 'PRIMARY';
// PRIMARY_ROLE:                                          'PRIMARY_ROLE';
PRIOR    : 'PRIOR';
PRIORITY : 'PRIORITY';
// PRIORITY_LEVEL:                                        'PRIORITY_LEVEL';
// PRIVATE:                                               'PRIVATE';
// PRIVATE_KEY:                                           'PRIVATE_KEY';
PRIVILEGES: 'PRIVILEGES';
// PROC:                                                  'PROC';
PROCEDURE      : 'PROCEDURE';
PROCEDURES     : 'PROCEDURES';
PROCEDURE_NAME : 'PROCEDURE_NAME';
// PROCESS:                                               'PROCESS';
// PROFILE:                                               'PROFILE';
PROPERTY : 'PROPERTY';
PROVIDER : 'PROVIDER';
// PROVIDER_KEY_NAME:                                     'PROVIDER_KEY_NAME';
PUBLIC                              : 'PUBLIC';
PURGE                               : 'PURGE';
PUT                                 : 'PUT';
PYTHON                              : 'PYTHON';
QUALIFY                             : 'QUALIFY';
QUARTER                             : 'QUARTER';
QUERIES                             : 'QUERIES';
QUERY                               : 'QUERY';
QUERY_ACCELERATION_MAX_SCALE_FACTOR : 'QUERY_ACCELERATION_MAX_SCALE_FACTOR';
QUERY_TAG                           : 'QUERY_TAG';
QUEUE                               : 'QUEUE';
QUOTED_IDENTIFIERS_IGNORE_CASE      : 'QUOTED_IDENTIFIERS_IGNORE_CASE';
RANGE: 'RANGE';
RANK        : 'RANK';
RAW_DEFLATE : 'RAW_DEFLATE';
READ        : 'READ';
READER      : 'READER';
// READONLY:                                              'READONLY';
// READPAST:                                              'READPAST';
// READTEXT:                                              'READTEXT';
// READWRITE:                                             'READWRITE';
// READ_COMMITTED_SNAPSHOT:                               'READ_COMMITTED_SNAPSHOT';
// READ_ONLY:                                             'READ_ONLY';
// READ_ONLY_ROUTING_LIST:                                'READ_ONLY_ROUTING_LIST';
// READ_WRITE:                                            'READ_WRITE';
// REBUILD:                                               'REBUILD';
// RECEIVE:                                               'RECEIVE';
RECLUSTER: 'RECLUSTER';
// RECOMPILE:                                             'RECOMPILE';
// RECONFIGURE:                                           'RECONFIGURE';
RECORD_DELIMITER: 'RECORD_DELIMITER';
// RECOVERY:                                              'RECOVERY';
RECURSIVE: 'RECURSIVE';
// RECURSIVE_TRIGGERS:                                    'RECURSIVE_TRIGGERS';
REFERENCES        : 'REFERENCES';
REFERENCE_USAGE   : 'REFERENCE_USAGE';
REFRESH           : 'REFRESH';
REFRESH_MODE      : 'REFRESH_MODE';
REFRESH_ON_CREATE : 'REFRESH_ON_CREATE';
REGION            : 'REGION';
REGIONS           : 'REGIONS';
REGION_GROUP      : 'REGION_GROUP';
// RELATIVE:                                              'RELATIVE';
RELY: 'RELY';
// REMOTE:                                                'REMOTE';
// REMOTE_PROC_TRANSACTIONS:                              'REMOTE_PROC_TRANSACTIONS';
// REMOTE_SERVICE_NAME:                                   'REMOTE_SERVICE_NAME';
REMOVE                     : 'REMOVE';
RENAME                     : 'RENAME';
REPEATABLE                 : 'REPEATABLE';
REPLACE                    : 'REPLACE';
REPLACE_INVALID_CHARACTERS : 'REPLACE_INVALID_CHARACTERS';
REPLICA                    : 'REPLICA';
REPLICATION                : 'REPLICATION';
REPLICATION_SCHEDULE       : 'REPLICATION_SCHEDULE';
REPOSITORY                 : 'REPOSITORY';
REPOSITORIES               : 'REPOSITORIES';
REQUEST_TRANSLATOR         : 'REQUEST_TRANSLATOR';
// REQUIRED:                                              'REQUIRED';
REQUIRE_STORAGE_INTEGRATION_FOR_STAGE_CREATION: 'REQUIRE_STORAGE_INTEGRATION_FOR_STAGE_CREATION';
REQUIRE_STORAGE_INTEGRATION_FOR_STAGE_OPERATION:
    'REQUIRE_STORAGE_INTEGRATION_FOR_STAGE_OPERATION'
;
RESET               : 'RESET';
RESOURCE            : 'RESOURCE';
RESOURCES           : 'RESOURCES';
RESOURCE_MONITOR    : 'RESOURCE_MONITOR';
RESPECT             : 'RESPECT';
RESPONSE_TRANSLATOR : 'RESPONSE_TRANSLATOR';
// RESTART:                                               'RESTART';
// RESTORE:                                               'RESTORE';
RESTRICT     : 'RESTRICT';
RESTRICTIONS : 'RESTRICTIONS';
RESULT       : 'RESULT';
RESUME       : 'RESUME';
// RETAINDAYS:                                            'RETAINDAYS';
// RETURN:                                                'RETURN';
RETRY              : 'RETRY';
RETURNS            : 'RETURNS';
RETURN_ALL_ERRORS  : 'RETURN_ALL_ERRORS';
RETURN_ERRORS      : 'RETURN_ERRORS';
RETURN_FAILED_ONLY : 'RETURN_FAILED_ONLY';
RETURN_N_ROWS      : 'RETURN_' DEC_DIGIT+ '_ROWS';
RETURN_ROWS        : 'RETURN_ROWS';
// REVERSE:                                               'REVERSE';
// REVERT:                                                'REVERT';
REVOKE: 'REVOKE';
// REWIND:                                                'REWIND';
RIGHT         : 'RIGHT';
RLIKE         : 'RLIKE';
REGEXP        : 'REGEXP';
ROLE          : 'ROLE';
ROLES         : 'ROLES';
ROLLBACK      : 'ROLLBACK';
ROLLUP        : 'ROLLUP';
ROUND         : 'ROUND';
ROUNDING_MODE : 'ROUNDING_MODE';
// ROOT:                                                  'ROOT';
ROW: 'ROW';
// ROWCOUNT:                                              'ROWCOUNT';
// ROWGUID:                                               'ROWGUID';
// ROWLOCK:                                               'ROWLOCK';
ROWS               : 'ROWS';
ROWS_PER_RESULTSET : 'ROWS_PER_RESULTSET';
ROW_NUMBER         : 'ROW_NUMBER';
RSA_PUBLIC_KEY     : 'RSA_PUBLIC_KEY';
RSA_PUBLIC_KEY_2   : 'RSA_PUBLIC_KEY_2';
RTRIM              : 'RTRIM';
RUN_AS_ROLE        : 'RUN_AS_ROLE';
RUNTIME_VERSION    : 'RUNTIME_VERSION';
S3                 : '\'S3\'';
// SAFE:                                                  'SAFE';
// SAFETY:                                                'SAFETY';
SAML2                               : 'SAML2';
SAML2_ENABLE_SP_INITIATED           : 'SAML2_ENABLE_SP_INITIATED';
SAML2_FORCE_AUTHN                   : 'SAML2_FORCE_AUTHN';
SAML2_ISSUER                        : 'SAML2_ISSUER';
SAML2_POST_LOGOUT_REDIRECT_URL      : 'SAML2_POST_LOGOUT_REDIRECT_URL';
SAML2_PROVIDER                      : 'SAML2_PROVIDER';
SAML2_REQUESTED_NAMEID_FORMAT       : 'SAML2_REQUESTED_NAMEID_FORMAT';
SAML2_SIGN_REQUEST                  : 'SAML2_SIGN_REQUEST';
SAML2_SNOWFLAKE_ACS_URL             : 'SAML2_SNOWFLAKE_ACS_URL';
SAML2_SNOWFLAKE_ISSUER_URL          : 'SAML2_SNOWFLAKE_ISSUER_URL';
SAML2_SNOWFLAKE_X509_CERT           : 'SAML2_SNOWFLAKE_X509_CERT';
SAML2_SP_INITIATED_LOGIN_PAGE_LABEL : 'SAML2_SP_INITIATED_LOGIN_PAGE_LABEL';
SAML2_SSO_URL                       : 'SAML2_SSO_URL';
SAML2_X509_CERT                     : 'SAML2_X509_CERT';
SAML_IDENTITY_PROVIDER              : 'SAML_IDENTITY_PROVIDER';
SAMPLE                              : 'SAMPLE';
SAVE_OLD_URL                        : 'SAVE_OLD_URL';
SCALE                               : 'SCALE';
SCALING_POLICY                      : 'SCALING_POLICY';
SCHEDULE                            : 'SCHEDULE';
// SCHEDULER:                                             'SCHEDULER';
SCHEMA  : 'SCHEMA';
SCHEMAS : 'SCHEMAS';
// SCHEME:                                                'SCHEME';
SCIM        : 'SCIM';
SCIM_CLIENT : 'SCIM_CLIENT';
// SCRIPT:                                                'SCRIPT';
SEARCH    : 'SEARCH';
SECONDARY : 'SECONDARY';
// SECONDARY_ONLY:                                        'SECONDARY_ONLY';
// SECONDARY_ROLE:                                        'SECONDARY_ROLE';
// SECONDS:                                               'SECONDS';
SECRET        : 'SECRET';
SECRETS       : 'SECRETS';
SECRET_STRING : 'SECRET_STRING';
SECURE        : 'SECURE';
SECURITY      : 'SECURITY';
SECURITYADMIN : 'SECURITYADMIN';
SEED          : 'SEED';
SELECT        : 'SELECT';
// SELF:                                                  'SELF';
SEQUENCE  : 'SEQUENCE';
SEQUENCES : 'SEQUENCES';
// SERVER:                                                'SERVER';
// SERVICE:                                               'SERVICE';
SESSION                      : 'SESSION';
SESSION_IDLE_TIMEOUT_MINS    : 'SESSION_IDLE_TIMEOUT_MINS';
SESSION_POLICY               : 'SESSION_POLICY';
SESSION_UI_IDLE_TIMEOUT_MINS : 'SESSION_UI_IDLE_TIMEOUT_MINS';
SET                          : 'SET';
SETS                         : 'SETS';
// SETUSER:                                               'SETUSER';
SHARE: 'SHARE';
// SHARED:                                                'SHARED';
SHARES             : 'SHARES';
SHARE_RESTRICTIONS : 'SHARE_RESTRICTIONS';
SHOW               : 'SHOW';
SHOW_INITIAL_ROWS  : 'SHOW_INITIAL_ROWS';
// SIGNATURE:                                             'SIGNATURE';
SIMPLE                          : 'SIMPLE';
SIMULATED_DATA_SHARING_CONSUMER : 'SIMULATED_DATA_SHARING_CONSUMER';
// SINGLE_USER:                                           'SINGLE_USER';
// SIZE:                                                  'SIZE';
SIZE_LIMIT           : 'SIZE_LIMIT';
SKIP_                : 'SKIP';
SKIP_BLANK_LINES     : 'SKIP_BLANK_LINES';
SKIP_BYTE_ORDER_MARK : 'SKIP_BYTE_ORDER_MARK';
SKIP_FILE            : 'SKIP_FILE';
SKIP_FILE_N          : 'SKIP_FILE_' DEC_DIGIT+;
SKIP_HEADER          : 'SKIP_HEADER';
SMALL                : 'SMALL';
SNAPPY               : 'SNAPPY';
SNAPPY_COMPRESSION   : 'SNAPPY_COMPRESSION';
SNOWFLAKE_FULL       : 'SNOWFLAKE_FULL';
SNOWFLAKE_SSE        : 'SNOWFLAKE_SSE';
SNOWPARK_OPTIMIZED   : '\'SNOWPARK-OPTIMIZED\'';
SOME                 : 'SOME';
// SOUNDEX:                                               'SOUNDEX';
SOURCE             : 'SOURCE';
SOURCE_COMPRESSION : 'SOURCE_COMPRESSION';
// SPACE_KEYWORD:                                         'SPACE';
// SPARSE:                                                'SPARSE';
// SPECIFICATION:                                         'SPECIFICATION';
SPLIT              : 'SPLIT';
SPLIT_PART         : 'SPLIT_PART';
SPLIT_TO_TABLE     : 'SPLIT_TO_TABLE';
SQL                : 'SQL';
SSO_LOGIN_PAGE     : 'SSO_LOGIN_PAGE';
STAGE              : 'STAGE';
STAGES             : 'STAGES';
STAGE_COPY_OPTIONS : 'STAGE_COPY_OPTIONS';
STAGE_FILE_FORMAT  : 'STAGE_FILE_FORMAT';
STANDARD           : 'STANDARD';
// STANDBY:                                               'STANDBY';
START: 'START';
// STARTED:                                               'STARTED';
STARTS                              : 'STARTS';
START_DATE                          : 'START_DATE';
START_TIMESTAMP                     : 'START_TIMESTAMP';
STATE                               : 'STATE';
STATEMENT                           : 'STATEMENT';
STATEMENT_QUEUED_TIMEOUT_IN_SECONDS : 'STATEMENT_QUEUED_TIMEOUT_IN_SECONDS';
STATEMENT_TIMEOUT_IN_SECONDS        : 'STATEMENT_TIMEOUT_IN_SECONDS';
// STATIC:                                                'STATIC';
// STATISTICS:                                            'STATISTICS';
STATS: 'STATS';
// STATS_DATE:                                            'STATS_DATE';
// STATS_STREAM:                                          'STATS_STREAM';
STATUS: 'STATUS';
// STATUSONLY:                                            'STATUSONLY';
// STDEV:                                                 'STDEV';
// STDEVP:                                                'STDEVP';
// STOP:                                                  'STOP';
// STOPLIST:                                              'STOPLIST';
// STOPPED:                                               'STOPPED';
STORAGE                   : 'STORAGE';
STORAGE_ALLOWED_LOCATIONS : 'STORAGE_ALLOWED_LOCATIONS';
STORAGE_AWS_OBJECT_ACL    : 'STORAGE_AWS_OBJECT_ACL';
STORAGE_AWS_ROLE_ARN      : 'STORAGE_AWS_ROLE_ARN';
STORAGE_BLOCKED_LOCATIONS : 'STORAGE_BLOCKED_LOCATIONS';
STORAGE_INTEGRATION       : 'STORAGE_INTEGRATION';
STORAGE_PROVIDER          : 'STORAGE_PROVIDER';
// STR:                                                   'STR';
STREAM             : 'STREAM';
STREAMS            : 'STREAMS';
STRICT             : 'STRICT';
STRICT_JSON_OUTPUT : 'STRICT_JSON_OUTPUT';
// STRING_AGG:                                            'STRING_AGG';
// STRING_ESCAPE:                                         'STRING_ESCAPE';
STRIP_NULL_VALUES   : 'STRIP_NULL_VALUES';
STRIP_OUTER_ARRAY   : 'STRIP_OUTER_ARRAY';
STRIP_OUTER_ELEMENT : 'STRIP_OUTER_ELEMENT';
SUBSTR              : 'SUBSTR';
SUBSTRING           : 'SUBSTRING';
SUM                 : 'SUM';
// SUPPORTED:                                             'SUPPORTED';
SUSPEND                         : 'SUSPEND';
SUSPENDED                       : 'SUSPENDED';
SUSPEND_IMMEDIATE               : 'SUSPEND_IMMEDIATE';
SUSPEND_TASK_AFTER_NUM_FAILURES : 'SUSPEND_TASK_AFTER_NUM_FAILURES';
SWAP                            : 'SWAP';
// SWITCH:                                                'SWITCH';
SYMMETRIC_KEY : 'SYMMETRIC_KEY';
SYNC_PASSWORD : 'SYNC_PASSWORD';
SYSADMIN      : 'SYSADMIN';
SYSTEM        : 'SYSTEM';
// SYSTEM_USER:                                           'SYSTEM_USER';
TABLE           : 'TABLE';
TABLEAU_DESKTOP : 'TABLEAU_DESKTOP';
TABLEAU_SERVER  : 'TABLEAU_SERVER';
TABLES          : 'TABLES';
TABLESAMPLE     : 'TABLESAMPLE';
TABLE_FORMAT    : 'TABLE_FORMAT';
TABULAR         : 'TABULAR';
TAG             : 'TAG';
TAGS            : 'TAGS';
// TARGET:                                                'TARGET';
TARGET_LAG : 'TARGET_LAG';
TASK       : 'TASK';
TASKS      : 'TASKS';
TEMP       : 'TEMP';
TEMPORARY  : 'TEMPORARY';
TERSE      : 'TERSE';
// TEXTSIZE:                                              'TEXTSIZE';
THEN: 'THEN';
// TIES:                                                  'TIES';
TIME     : 'TIME';
TIMEADD  : 'TIMEADD';
TIMEDIFF : 'TIMEDIFF';
// TIMEOUT:                                               'TIMEOUT';
// TIMER:                                                 'TIMER';
TIMESTAMP                   : 'TIMESTAMP';
TIMESTAMP_DAY_IS_ALWAYS_24H : 'TIMESTAMP_DAY_IS_ALWAYS_24H';
TIMESTAMP_FORMAT            : 'TIMESTAMP_FORMAT';
TIMESTAMP_INPUT_FORMAT      : 'TIMESTAMP_INPUT_FORMAT';
TIMESTAMP_LTZ               : 'TIMESTAMP' '_'? 'LTZ';
TIMESTAMP_LTZ_OUTPUT_FORMAT : 'TIMESTAMP_LTZ_OUTPUT_FORMAT';
TIMESTAMP_NTZ               : 'TIMESTAMP' '_'? 'NTZ';
TIMESTAMP_NTZ_OUTPUT_FORMAT : 'TIMESTAMP_NTZ_OUTPUT_FORMAT';
TIMESTAMP_OUTPUT_FORMAT     : 'TIMESTAMP_OUTPUT_FORMAT';
TIMESTAMP_TYPE_MAPPING      : 'TIMESTAMP_TYPE_MAPPING';
TIMESTAMP_TZ                : 'TIMESTAMP' '_'? 'TZ';
TIMESTAMP_TZ_OUTPUT_FORMAT  : 'TIMESTAMP_TZ_OUTPUT_FORMAT';
TIMESTAMPADD                : 'TIMESTAMPADD';
TIMESTAMPDIFF               : 'TIMESTAMPDIFF';
TIMEZONE                    : 'TIMEZONE';
TIME_FORMAT                 : 'TIME_FORMAT';
TIME_INPUT_FORMAT           : 'TIME_INPUT_FORMAT';
TIME_OUTPUT_FORMAT          : 'TIME_OUTPUT_FORMAT';
TO                          : 'TO';
TO_BOOLEAN                  : 'TO_BOOLEAN';
TO_DATE                     : 'TO_DATE';
TO_TIMESTAMP                : 'TO_TIMESTAMP';
TOP                         : 'TOP';
// TRACKING:                                              'TRACKING';
// TRACK_CAUSALITY:                                       'TRACK_CAUSALITY';
// TRAN:                                                  'TRAN';
TRANSACTION                         : 'TRANSACTION';
TRANSACTIONS                        : 'TRANSACTIONS';
TRANSACTION_ABORT_ON_ERROR          : 'TRANSACTION_ABORT_ON_ERROR';
TRANSACTION_DEFAULT_ISOLATION_LEVEL : 'TRANSACTION_DEFAULT_ISOLATION_LEVEL';
// TRANSACTION_ID:                                        'TRANSACTION_ID';
// TRANSFORM_NOISE_WORDS:                                 'TRANSFORM_NOISE_WORDS';
TRANSIENT: 'TRANSIENT';
// TRANSLATE:                                             'TRANSLATE';
// TRIGGER:                                               'TRIGGER';
TRIGGERS   : 'TRIGGERS';
TRIM       : 'TRIM';
TRIM_SPACE : 'TRIM_SPACE';
// TRIPLE_DES:                                            'TRIPLE_DES';
// TRIPLE_DES_3KEY:                                       'TRIPLE_DES_3KEY';
TRUE            : 'TRUE';
TRUNC           : 'TRUNC';
TRUNCATE        : 'TRUNCATE';
TRUNCATECOLUMNS : 'TRUNCATECOLUMNS';
// TRY:                                                   'TRY';
TRY_CAST: 'TRY_CAST';
// TSEQUAL:                                               'TSEQUAL';
TWO_DIGIT_CENTURY_START: 'TWO_DIGIT_CENTURY_START';
// TWO_DIGIT_YEAR_CUTOFF:                                 'TWO_DIGIT_YEAR_CUTOFF';
TYPE: 'TYPE';
// TYPEPROPERTY:                                          'TYPEPROPERTY';
// TYPE_ID:                                               'TYPE_ID';
// TYPE_NAME:                                             'TYPE_NAME';
// TYPE_WARNING:                                          'TYPE_WARNING';
// UN:                                                    'UN';
UNBOUNDED: 'UNBOUNDED';
// UNCHECKED:                                             'UNCHECKED';
// UNCOMMITTED:                                           'UNCOMMITTED';
UNDROP: 'UNDROP';
// UNICODE:                                               'UNICODE';
UNION  : 'UNION';
UNIQUE : 'UNIQUE';
// UNKNOWN:                                               'UNKNOWN';
// UNLIMITED:                                             'UNLIMITED';
// UNLOCK:                                                'UNLOCK';
// UNMASK:                                                'UNMASK';
UNMATCHED : 'UNMATCHED';
UNPIVOT   : 'UNPIVOT';
// UNSAFE:                                                'UNSAFE';
UNSET                  : 'UNSET';
UNSUPPORTED_DDL_ACTION : 'UNSUPPORTED_DDL_ACTION';
// UOW:                                                   'UOW';
UPDATE: 'UPDATE';
// UPDLOCK:                                               'UPDLOCK';
UPPER : 'UPPER';
URL   : 'URL';
USAGE : 'USAGE';
USE   : 'USE';
// USED:                                                  'USED';
USER                                     : 'USER';
USERADMIN                                : 'USERADMIN';
USERS                                    : 'USERS';
USERNAME                                 : 'USERNAME';
USER_SPECIFIED                           : 'USER_SPECIFIED';
USER_TASK_MANAGED_INITIAL_WAREHOUSE_SIZE : 'USER_TASK_MANAGED_INITIAL_WAREHOUSE_SIZE';
USER_TASK_TIMEOUT_MS                     : 'USER_TASK_TIMEOUT_MS';
USE_ANY_ROLE                             : 'USE_ANY_ROLE';
USE_CACHED_RESULT                        : 'USE_CACHED_RESULT';
USING                                    : 'USING';
UTF8                                     : 'UTF8';
VALIDATE                                 : 'VALIDATE';
// VALIDATION:                                            'VALIDATION';
VALIDATION_MODE: 'VALIDATION_MODE';
// VALID_XML:                                             'VALID_XML';
VALUE  : 'VALUE';
VALUES : 'VALUES';
// VAR:                                                   'VAR';
VARIABLES: 'VARIABLES';
// VARP:                                                  'VARP';
// VARYING:                                               'VARYING';
VECTOR   : 'VECTOR';
VERSION  : 'VERSION';
VERSIONS : 'VERSIONS';
VIEW     : 'VIEW';
VIEWS    : 'VIEWS';
// VIEW_METADATA:                                         'VIEW_METADATA';
VISIBILITY : 'VISIBILITY';
VOLATILE   : 'VOLATILE';
// WAIT:                                                  'WAIT';
WAREHOUSE           : 'WAREHOUSE';
WAREHOUSES          : 'WAREHOUSES';
WAREHOUSE_SIZE      : 'WAREHOUSE_SIZE';
WAREHOUSE_TYPE      : 'WAREHOUSE_TYPE';
WEEKLY              : 'WEEKLY';
WEEK_OF_YEAR_POLICY : 'WEEK_OF_YEAR_POLICY';
WEEK_START          : 'WEEK_START';
// WELL_FORMED_XML:                                       'WELL_FORMED_XML';
WHEN   : 'WHEN';
WHERE  : 'WHERE';
WITH   : 'WITH';
WITHIN : 'WITHIN';
// WITHOUT:                                               'WITHOUT';
// WITHOUT_ARRAY_WRAPPER:                                 'WITHOUT_ARRAY_WRAPPER';
WORK: 'WORK';
// WORKLOAD:                                              'WORKLOAD';
WRITE    : 'WRITE';
X4LARGE  : 'X4LARGE';
X5LARGE  : 'X5LARGE';
X6LARGE  : 'X6LARGE';
XLARGE   : 'XLARGE';
XML      : 'XML';
XML_Q    : '\'XML\'';
XSMALL   : 'XSMALL';
XXLARGE  : 'XXLARGE';
XXXLARGE : 'XXXLARGE';
YEARLY   : 'YEARLY';
YEAR     : 'YEAR';
ZSTD     : 'ZSTD';

ARRAY            : 'ARRAY';
ARRAY_Q          : '\'ARRAY\'';
BIGINT           : 'BIGINT';
BINARY           : 'BINARY';
BOOLEAN          : 'BOOLEAN';
BYTEINT          : 'BYTEINT';
CHAR_VARYING     : 'CHAR VARYING';
DATE             : 'DATE';
DATETIME         : 'DATETIME';
DECIMAL_         : 'DECIMAL';
DOUBLE           : 'DOUBLE';
DOUBLE_PRECISION : 'DOUBLE PRECISION';
FLOAT4           : 'FLOAT4';
FLOAT8           : 'FLOAT8';
FLOAT_           : 'FLOAT';
FLOOR            : 'FLOOR';
GEOGRAPHY        : 'GEOGRAPHY';
GEOMETRY         : 'GEOMETRY';
INTEGER          : 'INTEGER';
NCHAR            : 'NCHAR';
NCHAR_VARYING    : 'NCHAR VARYING';
NUMERIC          : 'NUMERIC';
NVARCHAR2        : 'NVARCHAR2';
NVARCHAR         : 'NVARCHAR';
REAL_            : 'REAL';
SMALLINT         : 'SMALLINT';
STRING_          : 'STRING';
TEXT             : 'TEXT';
TINYINT          : 'TINYINT';
VARBINARY        : 'VARBINARY';
VARCHAR          : 'VARCHAR';
VARIANT          : 'VARIANT';

LISTAGG: 'LISTAGG';

DUMMY: 'DUMMY'; //Dummy is not a keyword but rules reference it. As to be cleaned.

SPACE: [ \t\r\n]+ -> channel(HIDDEN);

SQL_COMMENT    : '/*' (SQL_COMMENT | .)*? '*/' -> channel(HIDDEN);
LINE_COMMENT   : '--' ~[\r\n]*                 -> channel(HIDDEN);
LINE_COMMENT_2 : '//' ~[\r\n]*                 -> channel(HIDDEN);

// TODO: ID can be not only Latin.
DOUBLE_QUOTE_ID    : '"' ~'"'+ '"';
DOUBLE_QUOTE_BLANK : '""';
SINGLE_QUOTE       : '\'';

ID  : [A-Z_] [A-Z0-9_@$]*;
ID2 : '$' [A-Z0-9_]*;

S3_PATH    : SINGLE_QUOTE 's3://' Uri SINGLE_QUOTE;
S3GOV_PATH : SINGLE_QUOTE 's3gov://' Uri SINGLE_QUOTE;
GCS_PATH   : SINGLE_QUOTE 'gcs://' Uri SINGLE_QUOTE;
AZURE_PATH : SINGLE_QUOTE 'azure://' Uri SINGLE_QUOTE;
FILE_PATH  : 'file://' ( DIVIDE Uri | WindowsPath); //file://<path_to_file>/<filename>

DBL_DOLLAR: '$$' (~'$' | '\\$' | '$' ~'$')*? '$$';

STRING: '\'' ('\\' . | '\'\'' | ~('\'' | '\\'))* '\'';

DECIMAL : DEC_DIGIT+;
FLOAT   : DEC_DOT_DEC;
REAL    : (DECIMAL | DEC_DOT_DEC) 'E' [+-]? DEC_DIGIT+;

CHAR_LITERAL: '\'' (~['\\\r\n] | EscapeSequence) '\'';

fragment EscapeSequence:
    '\\' [btnfr"'\\]
    | '\\' ([0-3]? [0-7])? [0-7]
    | '\\' 'u'+ HexDigit HexDigit HexDigit HexDigit
;

fragment HexDigit: [0-9a-f];

fragment HexString: [A-Z0-9|.] [A-Z0-9+\-|.]*;

fragment Uri: HexString (DIVIDE HexString)* DIVIDE?;

fragment WindowsPath: [A-Z] COLON '\\' HexString ('\\' HexString)* '\\'?;

ARROW : '->';
ASSOC : '=>';
FLOW : '->>';

NE   : '!=';
LTGT : '<>';
EQ   : '=';
GT   : '>';
GE   : '>=';
LT   : '<';
LE   : '<=';
// EXCLAMATION:         '!';

PIPE_PIPE : '||';
DOT       : '.';
// UNDERLINE:           '_';
AT   : '@';
AT_Q : '\'@\'';
//HASH:                '#';
DOLLAR      : '$';
LR_BRACKET  : '(';
RR_BRACKET  : ')';
LSB         : '[';
RSB         : ']';
LCB         : '{';
RCB         : '}';
COMMA       : ',';
SEMI        : ';';
COLON       : ':';
COLON_COLON : '::';
STAR        : '*';
DIVIDE      : '/';
MODULE      : '%';
PLUS        : '+';
MINUS       : '-';
TILDA       : '~';

fragment DEC_DOT_DEC : DEC_DIGIT+ DOT DEC_DIGIT+ | DEC_DIGIT+ DOT | DOT DEC_DIGIT+;
fragment DEC_DIGIT   : [0-9];