# ANTLR Snowflake Grammar

## Overview

The Snowflake ANTLR parser uses grammar files from a forked repository. Grammar files in this directory are managed via Maven and pulled from our fork rather than maintained directly in KOS.

**Upstream**: https://github.com/antlr/grammars-v4 (sql/snowflake/)
**Our Fork**: https://github.com/datadotworld/grammars-v4-snowflake
**Production Branch**: `snowflake-kos-modifications`
**License**: MIT License (Copyright (c) 2022, Michał Lorek)

---

## IntelliJ IDEA Setup for Large Generated Files

ANTLR-generated parser files (e.g., `SnowflakeParser.java`) can exceed IntelliJ's default file size limits, causing indexing issues and disabling code completion. To fix this:

### Steps

1. **Open Custom Properties**
   - Go to `Help` → `Edit Custom Properties...`
   - If prompted, create the file

2. **Add These Properties**
   ```properties
   # Maximum file size (in KB) for IntelliSense/autocomplete features
   idea.max.intellisense.filesize=10000

   # Maximum file size (in KB) that IntelliJ will load and parse
   idea.max.content.load.filesize=20000
   ```

3. **Restart IntelliJ IDEA**

---

## Pulling Grammar Files

Download grammar files from the fork (run from project root):

```bash
mvn initialize -P download-antlr-grammars -pl kos-collectors-snowflake
```

The `download-antlr-grammars` profile in `pom.xml` specifies the source URLs.

---

## Modifying the Grammar

### Process Overview

1. **Make changes** in the fork repository (`grammars-v4-snowflake`) on the `snowflake-kos-modifications` branch
2. **Document changes** in `sql/snowflake/KOS_MODIFICATIONS.md`
3. **Commit and push** to the fork
4. **Pull into KOS** using the Maven command above
5. **Regenerate parser** with `mvn clean install -pl kos-collectors-snowflake`
6. **Test** 

### Modification Workflow Options

**Option A - Edit in Fork:**
Edit grammar files directly in fork → commit/push → pull to KOS → test

**Option B - Edit in KOS First:**
Edit local grammar files → test → copy to fork → commit/push → confirm via download

Both approaches work. Option B allows faster iteration during development.

### Documentation

All grammar changes should be documented in the fork's `sql/snowflake/KOS_MODIFICATIONS.md` file with:
- Date and description
- File and line numbers
- Reason for change
- Whether it's upstream-compatible

---

## Fork Branch Strategy

**main branch**: Synced with upstream, minimal changes
**snowflake-kos-modifications branch**: Production branch with all KOS-specific changes

This separation allows easy upstream syncing while maintaining KOS customizations.

---

## License

MIT License - Copyright (c) 2022, Michał Lorek

Permits commercial use, modification, and distribution. Requires preservation of copyright notice and license text in grammar files.
